function [events] = event_function(model,events)
%
% Copyright 2008 Nick Van Damme

global end_time start_time
global tt xx div
cs = model.getconfigset('default');

%events
%time|species.name|amount|done

for i=1:size(events,1)
    event_time = events{i,1};
    if (event_time > end_time)
        % for sorted list of events: 
        break
    end
    if ( events{i,4}==0 ) %%end_time >= event_time (conditie al uitgesloten...)
        % simulate till event starting time -----------------------------------
        
        set(cs, 'StopTime', event_time-start_time );
        [t,x] = sbiosimulate(model, cs);
        tt = [tt ; t+repmat(start_time,length(t),1) ];
        xx = [xx zeros(size(xx,1),size(x,2)-size(xx,2)); x ];
        %adjust div
        div(2,:) = div(2,:) - repmat( event_time-start_time ,1,size(div,2)); %shift div
        %adjust initial conditions
        for j=1:size(x,2)
            model.species(j).InitialAmount = max(x(end,j),0);
        end

        % adjust settings for new simulations
        for j=i:size(events,1)
            if events{j,1} == events{i,1} %the same event_time??
                el = sbioselect('Type', 'species', 'Name', events{j,2});
                el(1).InitialAmount = events{j,3};
                events{j,4}=1;
            else 
                break 
                % ordened list, so if one event has starting time bigger than selected events, 
                % all other (following events) will also have a starting time bigger than selected events
            end
        end
        
        start_time = event_time;
    end
end